﻿-- Created 2019-04-30: 

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_FillCaseBufferGroup]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_FillCaseBufferGroup]
GO

CREATE PROCEDURE  [dbo].[VX_sp_FillCaseBufferGroup]
	@BrowseNbr int = 100, -- Should use f(NbrLoggedAgents)
	@ProjectId int = 0, -- Normally ignored
	@GroupNbr int = 0 , -- Default 0, ignored for project Roles
	@StrGroup char(3) = 'G00',
	@UseQuotas bit = 0,
	@dncFlag int = 1,
	@isPreviewSupported bit = 1,
	@dncExpirationDate datetime = 0,
	@FilterEmptyPhone bit = 0,
	@PhoneAlias nvarchar(32) = '',
	@ManualFilter int = null, -- (null (default), 0, 1)
	@TotalExtractedCases int OUT
AS
	SET @TotalExtractedCases = 0
	--##############################
	-- general : no weights - no replicates - no smoothing (GROUP Mode)
	--##############################
	INSERT INTO #BufferNewTemp (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
	SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, 
		case when @PhoneAlias = '' then Resphone else Phone.RpsContent end ResPhone, @ProjectId, Res.DialingMode 
	FROM Respondent Res with(nolock)
		left join Response Phone with(nolock) on @PhoneAlias <> '' and Res.ResRespondent = Phone.RpsRespondent and Phone.RpsQuestion = @PhoneAlias and Phone.RpsMatrix = 1 and Phone.RpsMention = 1 and Phone.RpsType = 0
	WHERE 
		/*Invariable criterion (should be same for every query in this SP */
		(ResBlocked = 0 or RestrictionOverride = 1) and (Res.Location = 'Server') and (ResActive = 1)
		and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
		and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
		and (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)) --Prevent double insert & remove excluded
		and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE ( @dncFlag = 1 AND resphone=phone ) OR (@dncFlag = 2 AND resphone=phone AND RegistrationDate > @dncExpirationDate ))) --Exclude DNC if active
		and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
		and (@FilterEmptyPhone = 0 or ((@PhoneAlias = '' and Res.Resphone <> '') or (@PhoneAlias <> '' and Phone.RpsContent is not null and Phone.RpsContent <> '')))
		-- Role not evaluated
		/*Variable criterion*/
		and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
		and (@ManualFilter is null or Res.ManualDialing = @ManualFilter)
	ORDER BY ResPriority desc, (case when rescallbackdate < '1901-01-01T00:00:00' then  '9999-12-31T23:59:59' else ResCallbackDate end), ResSeed
	SET @TotalExtractedCases = @@RowCount

GO
